﻿Imports System.Text
Public Class LAN

    '(0)クラス内変数
    Private LanSocket As System.Net.Sockets.TcpClient                                   'LAN ソケット
    Public MsgBuf As String = ""                                                        '受信データ

    '(1)接続
    Public Function OpenInterface(ByVal ipaddress As String, ByVal port As String) As Boolean
        Dim ret As Boolean = False
        Dim ip As System.Net.IPAddress = New System.Net.IPAddress(0)                    'IPアドレス

        Try
            If System.Net.IPAddress.TryParse(ipaddress, ip) Then
                LanSocket = New System.Net.Sockets.TcpClient                            'LANソケット生成
                LanSocket.NoDelay = True
                LanSocket.Connect(ip, Convert.ToInt32(port))                            '接続
                ret = True
            End If

        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        OpenInterface = ret

    End Function

    '(2)切断
    Public Function CloseInterface() As Boolean
        Dim ret As Boolean = False

        Try
            LanSocket.Close()                                                           'LANソケットクローズ
            ret = True
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

        CloseInterface = ret
    End Function

    '(3)コマンド送信
    Public Function SendMsg(ByVal strMsg As String) As Boolean
        Dim ret As Boolean = False
        Dim SendBuffer(1024) As Byte

        Try
            strMsg += vbCrLf                                                            'ターミネータ「CR+LF」を付加
            SendBuffer = System.Text.Encoding.Default.GetBytes(strMsg)                  'バイト型に変換
            LanSocket.GetStream().Write(SendBuffer, 0, SendBuffer.Length)               '送信バッファに書き込み
            ret = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        SendMsg = ret

    End Function

    '(4)受信
    Public Function ReceiveMsg(ByVal timeout_ms As Long) As Boolean
        Dim ret As Boolean = False
        Dim ary(65535) As Byte
        Dim rcv As String
        Dim len As Integer
        Dim buf As New StringBuilder()
        Dim sw As New Stopwatch()

        Try
            MsgBuf = ""                                                                 '受信データをクリア

            sw.Start()                                                                  'タイムアウト用ストップウォッチを開始
            'ターミネータ「LF」を受信するまでループ
            Do
                If LanSocket.GetStream().DataAvailable = True Then
                    len = LanSocket.GetStream().Read(ary, 0, ary.Length)                '受信バッファから読み取り
                    rcv = Encoding.Default.GetString(ary).Substring(0, len)
                    rcv = rcv.Replace(vbCr, "")                                         '受信データ内の「CR」を削除
                    If rcv.IndexOf(vbLf) >= 0 Then                                      'ターミネータ「LF」を受信したら終了
                        rcv = rcv.Substring(0, rcv.IndexOf(vbLf))                       '受信データを「LF」の手前までで切り詰め
                        buf.Append(rcv)                                                 '受信データを保存
                        MsgBuf = buf.ToString()
                        Exit Do
                    Else
                        buf.Append(rcv)                                                 '受信データを保存
                    End If
                End If

                'タイムアウト処理
                If sw.ElapsedMilliseconds > timeout_ms Then                             '受信データを保存
                    MsgBuf = "Timeout"
                    MsgBox(MsgBuf)
                    ReceiveMsg = ret
                    Exit Function
                End If

            Loop
            sw.Stop()                                                                   'ストップウォッチを停止
            ret = True

        Catch Ex As Exception
            MsgBuf = "Error"
            MsgBox(Ex.Message)
        End Try

        ReceiveMsg = ret

    End Function

    '(5)コマンド送受信
    Public Function SendQueryMsg(ByVal strMsg As String, ByVal timeout_ms As Long) As Boolean
        Dim ret As Boolean = False
        Dim ary(65535) As Byte

        If LanSocket.GetStream().DataAvailable = True Then
            LanSocket.GetStream().Read(ary, 0, ary.Length)                              '受信バッファにデータがあれば読み取り
        End If

        ret = SendMsg(strMsg)                                                           'コマンド送信
        If ret Then
            If InStr(strMsg, "?") <> 0 Then
                ret = ReceiveMsg(timeout_ms)                                            '送信が成功したら応答を受信
            End If
        End If

        SendQueryMsg = ret
    End Function

End Class
